unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function ExtensoMil(Numero : String) : String;
const
  Unidades : Array[1..19] of String = ('um','dois','trs','quatro',
    'cinco','seis','sete','oito','nove','dez','onze','doze','treze',
    'quatorze','quinze','dezesseis','dezessete','dezoito','dezenove');
  Dezenas : Array[2..9] of String = ('vinte','trinta','quarenta',
    'cincoenta','sessenta','setenta','oitenta','noventa');
  Centenas : Array[1..9] of String = ('cem','duzentos','trezentos',
    'quatrocentos','quinhentos','seiscentos','setecentos','oitocentos',
    'novecentos');
begin
  Result := '';
  if Numero[1] <> '0' then
    Result := Centenas[Ord(Numero[1])-Ord('0')];
  if StrToInt(Copy(Numero,2,2)) > 0 then begin
    if Result <> '' then
      Result := Result + ' e ';
    if StrToInt(Copy(Numero,2,2)) <= 19 then
      Result := Result + Unidades[StrToInt(Copy(Numero,2,2))]
    else begin
      Result := Result + Dezenas[Ord(Numero[2])-Ord('0')];
      if Numero[3] <> '0' then
        Result := Result + ' e ' + Unidades[Ord(Numero[3])-Ord('0')];
    end;
  end;
end;

function Extenso(Numero : String) : String;
const
  UnidSing : Array[0..5] of String = ('centavo','real','mil','milho','bilho','trilho');
  UnidPlur : Array[0..5] of String = ('centavos','reais','mil','milhes','bilhes','trilhes');
var
  Lista : TStringList;
  NumStr : String;
  i : Integer;
  JaLigou : Boolean;
  Texto : String;
  PosDec : Integer;
begin
  Lista := TStringList.Create;
  PosDec := Pos(DecimalSeparator,Numero);
  if PosDec > 0 then begin
    Lista.Add('0'+Copy(Numero,PosDec+1,2));
    NumStr := Copy(Numero,1,PosDec-1);
  end
  else begin
    Lista.Add('000');
    NumStr := Numero;
  end;  
  while NumStr <> '' do
    if Length(NumStr) > 3 then begin
      Lista.Add(Copy(NumStr,Length(NumStr)-2,3));
      NumStr := Copy(NumStr,1,Length(NumStr)-3);
    end
    else begin
      while Length(NumStr) < 3 do
        NumStr := '0'+NumStr;  
      Lista.Add(NumStr);
      NumStr := '';
    end;
  Result := '';
  JaLigou := False;
  for i := 0 to Lista.Count - 1 do begin
    if Lista[i] <> '000' then begin
      Texto := ExtensoMil(Lista[i]);
      if (Lista[i] <> '001') or ((i = 1) and (Lista.Count > 2)) then
        Texto := Texto + ' ' + UnidPlur[i]
      else
        Texto := Texto + ' ' + UnidSing[i];
      if (i = 2) and (Lista[1] = '000') then
        Texto := Texto + ' reais'
      else if (i > 2) and (Lista[2] = '000') and (Lista[1] = '000') then
        Texto := Texto + ' de reais';
      if Result <> '' then begin
        if JaLigou then
          Result := Texto + ', ' + Result
        else begin
          Result := Texto + ' e ' + Result;
          JaLigou := True;
        end;  
      end
      else
        Result := Texto;
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  try
    StrToFloat(Edit1.Text);
    Label2.Caption := Extenso(Edit1.Text);
  except
    On EConvertError do
      MessageDlg('Nmero Invlido',mtError,[mbOk],0);
  end;
end;

end.
